unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    PopupMenu1: TPopupMenu;
    Open1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDblClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
  private
    { Private declarations }
  public
    isFullScreen : Boolean;
    OldRect : TRect;
    OldStyle : Longint;
  end;

var
  Form1: TForm1;

implementation

uses Bass, BassVideo;

{$R *.dfm}
var chan : DWORD;

function myVideoProc(Handle : DWORD; Action, param1, param2 : DWORD; user : Pointer): BOOL; stdcall;
var R : TRect;
begin
 case Action of
  BassVideo_FoundVideo :
    begin
      R := Form1.ClientRect;
      R.Left := 0;
      R.Top := 0;
      BASSVideo_SetVideoWindow(Handle, Form1.Handle, R, 0);
    end;
 end;
 result := FALSE; // doesn't handle any msg
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Bass_Init(-1, 44100, 0, 0, nil);
 BassVideo_Init();
 if OpenDialog1.Execute then
  begin
    chan := BassVideo_StreamCreateFile(PChar(OpenDialog1.FileName), BASSVIDEO_AUTO_PAINT or BASSVIDEO_AUTO_RESIZE or BASSVIDEO_AUTO_MOVE, 0, @myVideoProc, nil);
    if chan <> 0 then
     BassVideo_Play(chan);
  end
 else
  Application.Terminate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 BassVideo_Free();
 Bass_Free;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 if Shift = [ssLeft] then
  begin
   ReleaseCapture;
   Perform(WM_SYSCOMMAND, $f012, 0);
  end;
end;

procedure TForm1.FormDblClick(Sender: TObject);
begin
 isFullScreen := not isFullScreen;
 if isFullScreen then
  begin
    OldRect.Left := Left;
    OldRect.Top := Top;
    OldRect.Right := Width;
    OldRect.Bottom := Height;
    OldStyle := GetWindowLong(Handle, GWL_STYLE);
    SetWindowLong(Handle, GWL_STYLE, WS_POPUPWINDOW or WS_VISIBLE);
    Left := 0;
    Top := 0;
    Height := Screen.Height;
    Width := Screen.Width;
  end
 else
  begin
   SetWindowLong(Handle, GWL_STYLE, OldStyle);
   SetWindowPos(Handle, 0, OldRect.Left , OldRect.Top, OldRect.Right, OldRect.Bottom , 0);
  end;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
  begin
    BassVideo_StreamFree(chan);
    chan := BassVideo_StreamCreateFile(PChar(OpenDialog1.FileName), BASSVIDEO_AUTO_PAINT or BASSVIDEO_AUTO_RESIZE or BASSVIDEO_AUTO_MOVE, 0, @myVideoProc, nil);
    if chan <> 0 then
     BassVideo_Play(chan);
  end

end;

end.
